-- MacroScript File
-- Created:       
-- Last Modified: 
-- Mesh validator
-- Version: 3ds Max 2012
-- Author: Attila Szabo
-- Modified: 
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

/* History

Nov 30 2012 - first version

NOTE TO LOCALIZATION
Only the headers should be localized

*/

macroScript mesh_validator_toggle 
	category: ~MESH_VALIDATOR_CATEGORY~
	internalCategory: "Mesh Validator Tools"
	ButtonText: ~MESH_VALIDATOR_TOOGLE_BUTTONTEXT~ 
	tooltip: ~MESH_VALIDATOR_TOOGLE_TOOLTIP~
(
	local iniSectionName = "MeshInspector"
	local iniEnabledName = "Enable"
	
	function getMeshValidatorActive =
	(
		-- ini settings control the state of the Mesh Validator across 3ds Max sessions
		-- per 3ds Max session state of the Mesh Validator is controlled via meshValidator interface properties
		return meshInspector.Enable 
	)
	
	function setMeshValidatorActive enabled = 
	(
		-- ini settings are not updated by the Mesh Validator tool, the user 
		-- (in this case this macro) is expected to update them as needed
		local maxIniFile = getMAXIniFile() 
		if enabled then
		(
			setINISetting maxIniFile iniSectionName iniEnabledName "1"
		)
		else
		(
			setINISetting maxIniFile iniSectionName iniEnabledName "0"
		)
		meshInspector.Enable = enabled
	)
	
	On isEnabled do 
	(
		true
	)

	on isChecked do 
	(
		getMeshValidatorActive()
	)
	
	On execute Do
	(
		if (getMeshValidatorActive()) then 
			setMeshValidatorActive(false)
		else
			setMeshValidatorActive(true)
	)

)

macroScript mesh_validator_auto_repair
	category: ~MESH_VALIDATOR_CATEGORY~
	internalCategory: "Mesh Validator Tools"
	ButtonText: ~MESH_VALIDATOR_AUTOREPAIR_BUTTONTEXT~ 
	tooltip: ~MESH_VALIDATOR_AUTOREPAIR_TOOLTIP~
(
	local iniSectionName = "MeshInspector"
	local iniRepairName = "Repair"
	local iniShowDialogName = "ShowDialog"
	
	function getAutoRepairEnabled =
	(
		-- ini settings control the state of the Mesh Validator across 3ds Max sessions
		-- per 3ds Max session state of the Mesh Validator is controlled via meshValidator interface properties
		return (meshInspector.RepairMesh and (not meshInspector.ShowDialog))
	)
	
	function setAutoRepairEnabled enabled = 
	(
		-- ini settings are not updated by the Mesh Validator tool, the user 
		-- (in this case this macro) is expected to update them as needed
		local maxIniFile = getMAXIniFile() 
		if enabled then
		(
			setINISetting maxIniFile iniSectionName iniRepairName "1"
			setINISetting maxIniFile iniSectionName iniShowDialogName "0"
		)
		else
		(
			setINISetting maxIniFile iniSectionName iniRepairName "1"
			setINISetting maxIniFile iniSectionName iniShowDialogName "1"
		)
		meshInspector.ShowDialog = (not enabled)
	)
	
	On isEnabled do 
	(
		true
	)

	on isChecked do 
	(
		getAutoRepairEnabled()
	)
	
	On execute Do
	(
		if (getAutoRepairEnabled()) then 
			setAutoRepairEnabled(false)
		else
			setAutoRepairEnabled(true)
	)

)
